Imports Microsoft.VisualBasic
Imports System.Data
Imports System.Data.SqlClient


Public Class EmailContentDB


    ''' <summary>
    ''' Zapisuje <see cref="EmailContent" /> po przesaniu jego tekstu
    ''' </summary>
    ''' <param name="content">Tre wiadomoci pocztowej do zachowania</param>
    Public Shared Sub SaveEmailContent(ByVal content As String)
        Using mConnection As New SqlConnection(Config.ConnectionString)

            Dim mCommand As SqlCommand = New SqlCommand("sprocEmailInsertUpdateItem", mConnection)
            mCommand.CommandType = CommandType.StoredProcedure
            mCommand.Parameters.AddWithValue("@text", content)
            mConnection.Open()
            mCommand.ExecuteNonQuery()
            mConnection.Close()

        End Using
    End Sub

    ''' <summary>
    ''' pobiera <see cref="EmailContent" /> z bazy danych
    ''' </summary>
    Public Shared Function GetEmailContent() As String

        Dim mText As String = ""

        Try
            Using mConnection As New SqlConnection(Config.ConnectionString)
                Dim mCommand As SqlCommand = New SqlCommand("sprocEmailSelectSingleItem", mConnection)
                mCommand.CommandType = CommandType.StoredProcedure
                mConnection.Open()
                Using mDataReader As SqlDataReader = mCommand.ExecuteReader(CommandBehavior.CloseConnection)
                    If mDataReader.Read() Then
                        mText = mDataReader.GetString(mDataReader.GetOrdinal("text"))
                    End If
                    mDataReader.Close()
                End Using
            End Using

        Catch ex As Exception
            'Wywoujc wyraenie "Throw" przekazujemy bd do pliku global.asax, ktry wykorzysta domyln stron obsugi bdw do przetworzenia bdu i wywietlenia uytkownikowi zdefiniowanego przez nas komunikatu o bdzie.
            Throw
        End Try

        Return mText
    End Function



    ''' <summary>
    ''' pobiera z bazy danych adres e-mail nadawcy pliku
    ''' </summary>
    Public Shared Function GetEmailSenderForResource(ByVal resourceID As Integer) As String
       Dim mSender As String = ""
       
        Try
            Using mConnection As New SqlConnection(Config.ConnectionString)
                Dim mCommand As SqlCommand = New SqlCommand( _
                    "sprocResourceSelectEmailInfo", mConnection)
                mCommand.CommandType = CommandType.StoredProcedure
                mCommand.Parameters.AddWithValue("@id", resourceID)
                mConnection.Open()
                Using mDataReader As SqlDataReader = _
                    mCommand.ExecuteReader(CommandBehavior.CloseConnection)
                    If mDataReader.Read() Then
                        mSender = mDataReader.GetString( _
                            mDataReader.GetOrdinal("email"))
                    End If
                    mDataReader.Close()
                End Using
            End Using

        Catch ex As Exception
            'Wywoujc wyraenie "Throw" przekazujemy bd do pliku global.asax, 
            'ktry wykorzysta domyln stron obsugi bdw do przetworzenia bdu
            'i wywietlenia uytkownikowi zdefiniowanego przez nas komunikatu o bdzie.
            Throw
        End Try

        Return mSender
    End Function



End Class
